####################################################################################################

#   Copyright (C) 2021 Dominique PUNSOLA

#   This file is part of Cognatus.
# 
#   Cognatus is free software: you can redistribute it and modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
# 
#   Cognatus is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with Cognatus.  If not, see <https://www.gnu.org/licenses/>.

####################################################################################################

#   Copyright (C) 2021 Dominique PUNSOLA

#   Ce fichier est une partie de Cognatus.
#   
#   Cognatus est un logiciel libre ; vous pouvez le redistribuer et le modifier 
#   au titre des clauses de la Licence Publique Gnrale GNU, telle que publie par 
#   la Free Software Foundation ; soit la version 3 de la Licence, ou 
#   ( votre discrtion) une version ultrieure quelconque. 
#   
#   Cognatus est distribu dans l'espoir qu'il sera utile, 
#   mais SANS AUCUNE GARANTIE ; sans mme une garantie implicite de 
#   COMMERCIABILITE ou DE CONFORMITE A UNE UTILISATION PARTICULIERE. Voir la 
#   Licence Publique Gnrale GNU pour plus de dtails. 
#   
#   Vous devriez avoir reu un exemplaire de la Licence Publique Gnrale GNU 
#   avec Cognatus ; si ce n'est pas le cas, voyez <https://www.gnu.org/licenses/>.

####################################################################################################
# mode debug

Set-StrictMode -Version 3

Add-Type -Name Window -Namespace Console -MemberDefinition '
[DllImport("Kernel32.dll")]
public static extern IntPtr GetConsoleWindow();
[DllImport("user32.dll")]
public static extern bool ShowWindow(IntPtr hWnd, Int32 nCmdShow);
'

####################################################################################################
# Assembly

Add-Type -AssemblyName System.Windows.Forms 
Add-Type -AssemblyName System.Drawing
[System.Windows.Forms.Application]::EnableVisualStyles()

$assemblyFile = (Resolve-Path ("System.Data.SQLite.dll")).path
[Reflection.Assembly]::LoadFile($assemblyFile) | Out-Null

####################################################################################################
# cration d'une base en mmoire
$global:conn_mem = New-Object -TypeName System.Data.SQLite.SQLiteConnection
$global:conn_mem.ConnectionString = "Data Source=" + ":memory:"
$global:conn_mem.Open()


####################################################################################################
# langue
$langue = (Get-WinSystemLocale).name.split('-')[0]
#  $langue = "nl"

####################################################################################################
# tables de libells

if ($langue -eq "es") {
$table_lib=@{}
$table_lib.add(1,"Conversin de calendarios (versin 1.1)")
$table_lib.add(2,"Gregoriano (>= 15 oct. 1582)")
$table_lib.add(3,"Julian (>= 1)")
$table_lib.add(4,"Convertir")
$table_lib.add(5,"Islmico (>= 1)")
$table_lib.add(6,"Fuente")
$table_lib.add(7,"El calendario solo est disponible a partir del ao 1753 (inicio del calendario gregoriano en los pases anglosajones)")
$table_lib.add(8,"Mostrar menos")
$table_lib.add(9,"Mostrar ms")
$table_lib.add(21,"El ao gregoriano debe ser inferior a 8000")
$table_lib.add(22,"El ao juliano debe ser inferior a 8000")
$table_lib.add(23,"El ao musulmn debe ser inferior a 7605")
} elseif ($langue -eq "it") {
$table_lib=@{}
$table_lib.add(1,"Conversione calendario (versione 1.1)")
$table_lib.add(2,"Gregoriano (>= 15 ott. 1582)")
$table_lib.add(3,"Giuliano (>= 1)")
$table_lib.add(4,"Converti")
$table_lib.add(5,"Musulmano (>= 1)")
$table_lib.add(6,"Fonte")
$table_lib.add(7,"Il calendario  disponibile solo dall'anno 1753 (inizio del calendario gregoriano nei paesi anglosassoni)")
$table_lib.add(8,"Mostra meno")
$table_lib.add(9,"Mostrar piu")
$table_lib.add(21,"L'anno gregoriano deve essere minore di 8000")
$table_lib.add(22,"L'anno giuliano deve essere minore di 8000")
$table_lib.add(23,"L'anno musulmano deve essere minore di 7605")
} elseif ($langue -eq "de") {
$table_lib=@{}
$table_lib.add(1,"Kalenderkonvertierung (version 1.1)")
$table_lib.add(2,"Gregorianisch (>= 15 Okt. 1582)")
$table_lib.add(3,"Julian (>= 1)")
$table_lib.add(4,"Konvertieren")
$table_lib.add(5,"Muslim  (>= 1)")
$table_lib.add(6,"Quelle")
$table_lib.add(7,"Der Kalender ist erst ab dem Jahr 1753 verfgbar (Beginn des gregorianischen Kalenders in angelschsischen Lndern)")
$table_lib.add(8,"Weniger anzeigen")
$table_lib.add(9,"Mehr anzeigen")
$table_lib.add(21,"Gregorianisches Jahr muss kleiner als 8000 sein")
$table_lib.add(22,"Julianisches Jahr muss kleiner als 8000 sein")
$table_lib.add(23,"Muslimisches Jahr muss weniger als 7605 sein")
} elseif ($langue -eq "nl") {
$table_lib=@{}
$table_lib.add(1,"Kalenders converteren (versie 1.1)")
$table_lib.add(2,"Gregoriaans (>= 15 Okt. 1582)")
$table_lib.add(3,"Juliaans (>= 1)")
$table_lib.add(4,"Converteren")
$table_lib.add(5,"Moslim  (>= 1)")
$table_lib.add(6,"Bron")
$table_lib.add(7,"De kalender is pas beschikbaar vanaf het jaar 1753 (begin van de Gregoriaanse kalender in Angelsaksische landen)")
$table_lib.add(8,"Toon minder")
$table_lib.add(9,"Toon meer")
$table_lib.add(21,"Het Gregoriaanse jaartal moet lager zijn dan 8000")
$table_lib.add(22,"Het Juliaanse jaartal moet minder zijn dan 8000")
$table_lib.add(23,"Het moslimjaar moet lager zijn dan 7605")
} else {
$table_lib=@{}
$table_lib.add(1,"Conversion de calendriers (version 1.1)")
$table_lib.add(2,"Gregorien (>= 15 oct. 1582)")
$table_lib.add(3,"Julien (>= 1)")
$table_lib.add(4,"Convertir")
$table_lib.add(5,"Musulman (>= 1)")
$table_lib.add(6,"Source")
$table_lib.add(7,"Le calendrier n'est disponible qu' partir de l'anne 1753 (dbut du calendrier grgorien dans les pays anglo-saxons)")
$table_lib.add(8,"Afficher moins")
$table_lib.add(9,"Afficher plus")
$table_lib.add(21,"L'anne grgorienne doit tre infrieure  8000")
$table_lib.add(22,"L'anne julienne doit tre infrieure  8000")
$table_lib.add(23,"L'anne musulmane doit tre infrieure  7605")
}

####################################################################################################
# tables de mois

if ($langue -eq "es") {
$table_mois=@{}
$table_mois.add(1,"Enero")
$table_mois.add(2,"Febrero")
$table_mois.add(3,"Marzo")
$table_mois.add(4,"Abril")
$table_mois.add(5,"Mayo")
$table_mois.add(6,"Junio")
$table_mois.add(7,"Julio")
$table_mois.add(8,"Agosto")
$table_mois.add(9,"Septiembre")
$table_mois.add(10,"Octubre")
$table_mois.add(11,"Noviembre")
$table_mois.add(12,"Diciembre")
} elseif ($langue -eq "it") {
$table_mois=@{}
$table_mois.add(1,"Gennaio")
$table_mois.add(2,"Febbraio")
$table_mois.add(3,"Marzo")
$table_mois.add(4,"Aprile")
$table_mois.add(5,"Maggio")
$table_mois.add(6,"Giugno")
$table_mois.add(7,"Luglio")
$table_mois.add(8,"Agosto")
$table_mois.add(9,"Settembre")
$table_mois.add(10,"Ottobre")
$table_mois.add(11,"Novembre")
$table_mois.add(12,"Dicembre")
} elseif ($langue -eq "de") {
$table_mois=@{}
$table_mois.add(1,"Januar")
$table_mois.add(2,"Februar")
$table_mois.add(3,"Mrz")
$table_mois.add(4,"April")
$table_mois.add(5,"Mai")
$table_mois.add(6,"Juni")
$table_mois.add(7,"Juli")
$table_mois.add(8,"August")
$table_mois.add(9,"September")
$table_mois.add(10,"Oktober")
$table_mois.add(11,"November")
$table_mois.add(12,"Dezember")
} elseif ($langue -eq "nl") {
$table_mois=@{}
$table_mois.add(1,"Januari")
$table_mois.add(2,"Februari")
$table_mois.add(3,"Maart")
$table_mois.add(4,"April")
$table_mois.add(5,"Mei")
$table_mois.add(6,"Juni")
$table_mois.add(7,"Juli")
$table_mois.add(8,"Augustus")
$table_mois.add(9,"September")
$table_mois.add(10,"Oktober")
$table_mois.add(11,"November")
$table_mois.add(12,"Dezember")
} else {
$table_mois=@{}
$table_mois.add(1,"Janvier")
$table_mois.add(2,"Fvrier")
$table_mois.add(3,"Mars")
$table_mois.add(4,"Avril")
$table_mois.add(5,"Mai")
$table_mois.add(6,"Juin")
$table_mois.add(7,"Juillet")
$table_mois.add(8,"Aot")
$table_mois.add(9,"Septembre")
$table_mois.add(10,"Octobre")
$table_mois.add(11,"Novembre")
$table_mois.add(12,"Dcembre")
}

$table_moisH=@{}
$table_moisH.add(1,"Mouharram")
$table_moisH.add(2,"Safar")
$table_moisH.add(3,"Rabia al-awwal")
$table_moisH.add(4,"Rabia ath-thani")
$table_moisH.add(5,"Joumada al oula")
$table_moisH.add(6,"Joumada ath-thania")
$table_moisH.add(7,"Rajab")
$table_moisH.add(8,"Chaabane")
$table_moisH.add(9,"Ramadan")
$table_moisH.add(10,"Chawwal")
$table_moisH.add(11,"Dhou al kada")
$table_moisH.add(12,"Dhou al-hijja")

####################################################################################################
# tables de jours

if ($langue -eq "es") {
$table_jour=@{}
$table_jour.add(1,"Lunes")
$table_jour.add(2,"Martes")
$table_jour.add(3,"Mircoles")
$table_jour.add(4,"Jeudi")
$table_jour.add(5,"Viernes")
$table_jour.add(6,"Sbado")
$table_jour.add(7,"Domingo")
} elseif ($langue -eq "it") {
$table_jour=@{}
$table_jour.add(1,"Luned")
$table_jour.add(2,"Marted")
$table_jour.add(3,"Mercoled")
$table_jour.add(4,"Gioved")
$table_jour.add(5,"Venerd")
$table_jour.add(6,"Sabato")
$table_jour.add(7,"Domenica")
} elseif ($langue -eq "de") {
$table_jour=@{}
$table_jour.add(1,"Montag")
$table_jour.add(2,"Dienstag")
$table_jour.add(3,"Mittwoch")
$table_jour.add(4,"Donnerstag")
$table_jour.add(5,"Freitag")
$table_jour.add(6,"Samstag")
$table_jour.add(7,"Sonntag")
} elseif ($langue -eq "de") {
$table_jour=@{}
$table_jour.add(1,"Maandag")
$table_jour.add(2,"Dinsdag")
$table_jour.add(3,"Woensdag")
$table_jour.add(4,"Donderdag")
$table_jour.add(5,"Vrijdag")
$table_jour.add(6,"Zaterdag")
$table_jour.add(7,"Zondag")
} else {
$table_jour=@{}
$table_jour.add(1,"Lundi")
$table_jour.add(2,"Mardi")
$table_jour.add(3,"Mercredi")
$table_jour.add(4,"Jeudi")
$table_jour.add(5,"Vendredi")
$table_jour.add(6,"Samedi")
$table_jour.add(7,"Dimanche")
}
####################################################################################################
# conversion de calendriers
$CalConvForm = New-Object System.Windows.Forms.Form -Property @{width = "450" ; height = "350" ; ControlBox = $true ; ShowInTaskBar = $true ; FormBorderStyle = "Fixed3D"
text = $table_lib[1] ; Icon = [System.Drawing.Icon]::ExtractAssociatedIcon((Resolve-Path ("evt.ico")).path)}
$CalConvToolTip     = New-Object System.Windows.Forms.ToolTip


############################# date grgorienne
$CalConvDateGlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 9" ; Size = "100, 38" ; Text = $table_lib[2] ; TextAlign="MiddleLeft"}
$CalConvForm.Controls.Add($CalConvDateGlabel)
$CalConvJourG     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "110, 13" ; width = "40" ; DropDownStyle = "DropDown" ; MaxDropDownItems = 35}
$CalConvForm.Controls.Add($CalConvJourG)
for($i = 1;$i -lt 32;$i++) {[void]$CalConvJourG.Items.add($i)}
$CalConvJourG.text = (get-date -format "dd")
$CalConvMoisG     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "160, 13" ; width = "120" ; DropDownStyle = "DropDownList"}
$CalConvForm.Controls.Add($CalConvMoisG)
[void]$CalConvMoisG.Items.add("")
for($i = 1;$i -lt 13;$i++) {[void]$CalConvMoisG.Items.add($table_mois[$i])}
$CalConvMoisG.text = $table_mois[[int](get-date -format MM)]
$CalConvAnG     = New-Object System.Windows.Forms.TextBox -Property @{Location = "290, 13" ; width = "40" }
$CalConvForm.Controls.Add($CalConvAnG)
$CalConvAnG.text = (get-date -format "yyyy")

$CalConvModifG     = New-Object System.Windows.Forms.TextBox -Property @{Location = "321, 13" ; Size = "18, 18" ; text = "y" ; visible = $false}
$CalConvForm.Controls.Add($CalConvModifG)
$CalConvJourG.add_textchanged({modifgg})
$CalConvJourG.add_selectedvaluechanged({modifgg})
$CalConvMoisG.add_textchanged({modifgg})
$CalConvMoisG.add_selectedvaluechanged({modifgg})
$CalConvAnG.add_textchanged({modifgg})

$CalConvG      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 13" ; Text = $table_lib[4]}
$CalConvG.add_Click({convG}) ; $CalConvForm.Controls.Add($CalConvG)


############################# date julienne
$CalConvDateJlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 44" ; Size = "100, 18" ; Text = $table_lib[3] ; TextAlign="MiddleLeft"}
$CalConvForm.Controls.Add($CalConvDateJlabel)
$CalConvJourJ     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "110, 43" ; width = "40" ; DropDownStyle = "DropDown" ; MaxDropDownItems = 35}
$CalConvForm.Controls.Add($CalConvJourJ)
for($i = 1;$i -lt 32;$i++) {[void]$CalConvJourJ.Items.add($i)}
$CalConvJourJ.text = ""
$CalConvMoisJ     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "160, 43" ; width = "120" ; DropDownStyle = "DropDownList"}
$CalConvForm.Controls.Add($CalConvMoisJ)
[void]$CalConvMoisJ.Items.add("")
for($i = 1;$i -lt 13;$i++) {[void]$CalConvMoisJ.Items.add($table_mois[$i])}
$CalConvMoisJ.text = ""
$CalConvAnJ     = New-Object System.Windows.Forms.TextBox -Property @{Location = "290, 43" ; width = "40"}
$CalConvForm.Controls.Add($CalConvAnJ)
$CalConvAnJ.text = ""

$CalConvModifJ     = New-Object System.Windows.Forms.TextBox -Property @{Location = "321, 43" ; Size = "100, 18" ; text = "y" ; visible = $false}
$CalConvForm.Controls.Add($CalConvModifJ)
$CalConvJourJ.add_textchanged({modifj})
$CalConvJourJ.add_selectedvaluechanged({modifj})
$CalConvMoisJ.add_textchanged({modifj})
$CalConvMoisJ.add_selectedvaluechanged({modifj})
$CalConvAnJ.add_textchanged({modifj})

$CalConvJ      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 43" ; Text = $table_lib[4]}
$CalConvJ.add_Click({convJ}) ; $CalConvForm.Controls.Add($CalConvJ)

############################# date hgire
$CalConvDateHlabel     = New-Object System.Windows.Forms.Label -Property @{Location = "10, 74" ; Size = "100, 18" ; Text = $table_lib[5] ; TextAlign="MiddleLeft"}
$CalConvForm.Controls.Add($CalConvDateHlabel)
$CalConvJourH     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "110, 73" ; width = "40" ; DropDownStyle = "DropDown" ; MaxDropDownItems = 35}
$CalConvForm.Controls.Add($CalConvJourH)
for($i = 1;$i -lt 31;$i++) {[void]$CalConvJourH.Items.add($i)}
$CalConvJourH.text = ""
$CalConvMoisH     = New-Object System.Windows.Forms.ComboBox -Property @{Location = "160, 73" ; width = "120" ; DropDownStyle = "DropDownList"}
$CalConvForm.Controls.Add($CalConvMoisH)
[void]$CalConvMoisH.Items.add("")
for($i = 1;$i -lt 13;$i++) {[void]$CalConvMoisH.Items.add($table_moisH[$i])}
$CalConvMoisH.text = ""
$CalConvAnH     = New-Object System.Windows.Forms.TextBox -Property @{Location = "290, 73" ; width = "40"}
$CalConvForm.Controls.Add($CalConvAnH)
$CalConvAnH.text = ""

$CalConvModifH     = New-Object System.Windows.Forms.TextBox -Property @{Location = "321, 73" ; Size = "18, 18" ; text = "y" ; visible = $false}
$CalConvForm.Controls.Add($CalConvModifH)
$CalConvJourH.add_textchanged({modifh})
$CalConvJourH.add_selectedvaluechanged({modifh})
$CalConvMoisH.add_textchanged({modifh})
$CalConvMoisH.add_selectedvaluechanged({modifh})
$CalConvAnH.add_textchanged({modifh})

$CalConvH      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 73" ; Text = $table_lib[4]}
$CalConvH.add_Click({convH}) ; $CalConvForm.Controls.Add($CalConvH)


############################# objet calendrier
$calendarConv = New-Object Windows.Forms.MonthCalendar -Property @{Location = "108, 105" ; ShowTodayCircle   = $false ; MaxSelectionCount = 1 ; name = "y" ; ShowToday = $false}
$CalConvForm.Controls.Add($calendarConv)
$calendarConv.MinDate = new-object System.DateTime(1753, 01, 01)
$calendarConv.MaxDate = new-object System.DateTime(7999, 12, 31)
$calendarConv.SelectionStart = new-object System.DateTime((get-date -format "yyyy"), (get-date -format "MM"), (get-date -format "dd"))
$CalConvAide     = New-Object System.Windows.Forms.Label -Property @{Location = "128, 145" ; Size = "180, 100" ; TextAlign="MiddleLeft"
 Text = $table_lib[7]}
$CalConvForm.Controls.Add($CalConvAide)

$CalConvJsemaine     = New-Object System.Windows.Forms.TextBox -Property @{Location = "128, 123" ; width = "80" ; enabled = $false}
$CalConvJsemaine.font  = new-object drawing.font($CalConvJsemaine.font,[Drawing.FontStyle]::Bold)
$CalConvForm.Controls.Add($CalConvJsemaine)

$calendarConv.add_dateChanged({
if ($calendarConv.name -eq "y") {
# [System.Windows.Forms.Messagebox]::Show($calendarConv.SelectionStart.month,"modifj")
$CalConvModifG.text = "x" ; $CalConvJourG.text = $calendarConv.SelectionStart.day ; 
#  $CalConvMoisG.text = (Get-Culture).DateTimeFormat.GetMonthName($calendarConv.SelectionStart.month) ; 
$CalConvMoisG.text = $table_mois[[int]($calendarConv.SelectionStart.month)]
$CalConvAnG.text = $calendarConv.SelectionStart.year
$CalConvModifG.text = "y" 
$CalConvModifJ.text = "x" ; $CalConvJourJ.text = "" ; $CalConvMoisJ.text = "" ; $CalConvAnJ.text = "" ;  $CalConvJsemaine.text = ""
$CalConvModifJ.text = "y"
$CalConvModifH.text = "x" ; $CalConvJourH.text = "" ; $CalConvMoisH.text = "" ; $CalConvAnH.text = ""
$CalConvModifH.text = "y"
}
})

############################# boutons Source, Affich, OK 
$CalConvSource     = New-Object System.Windows.Forms.Button -Property @{Location = "10, 275" ; width = "90" ; Text = $table_lib[6]}
$CalConvSource.add_Click({Start-Process "https://www.fourmilab.ch/documents/calendar/"})
$CalConvForm.Controls.Add($CalConvSource)
$CalConvToolTip.SetToolTip($CalConvSource, "https://www.fourmilab.ch/documents/calendar/")

$CalConvAffich      = New-Object System.Windows.Forms.Button -Property @{Location = "180, 275" ; width = "120" ; Text = $table_lib[8]}
$CalConvAffich.add_Click({
if ($CalConvAffich.text -eq $table_lib[8]) {
$CalConvForm.height = 180 ; $CalConvAffich.text = $table_lib[9]
$CalConvAffich.Location = "180, 105" ; $CalConvSource.Location = "10, 105" ; $CalConvOK.Location = "340, 105" ; $CalConvAide.visible = $false ; $CalConvJsemaine.visible = $false
$calendarConv.Location = "108, 185"} else {
$CalConvForm.height = 350 ; $CalConvAffich.text = $table_lib[8]
$CalConvAffich.Location = "180, 275" ; $CalConvSource.Location = "10, 275" ; $CalConvOK.Location = "340, 275" ; $CalConvAide.visible = $true ; $CalConvJsemaine.visible = $true
$calendarConv.Location = "108, 105"}
})
$CalConvForm.Controls.Add($CalConvAffich)

$CalConvOK      = New-Object System.Windows.Forms.Button -Property @{Location = "340, 275" ; Text = "OK"}
$CalConvOK.add_Click({$CalConvForm.visible = $false}) ; $CalConvForm.Controls.Add($CalConvOK)
$CalConvForm.CancelButton  = $CalConvOK

####################################################################################################
# conversion de calendriers : fonctions
function calconv {
$CalConvForm.visible = $true
$x = $ecran.width - 500 ; $y = 610
$CalConvForm.location = new-object System.Drawing.Point $x,$y
} 

function modifgg {
if ($CalConvModifG.text -eq "y") {
$CalConvModifJ.text = "x" ; $CalConvJourJ.text = "" ; $CalConvMoisJ.text = "" ; $CalConvAnJ.text = "" ; $CalConvJsemaine.text = ""
$CalConvModifJ.text = "y" 
$CalConvModifH.text = "x" ; $CalConvJourH.text = "" ; $CalConvMoisH.text = "" ; $CalConvAnH.text = ""
$CalConvModifH.text = "y" 
if ($CalConvJourG.text -ne "" -and $CalConvMoisG.text -ne "" -and $CalConvAnG.text -ne "") { 
for($i = 1;$i -lt 13;$i++){if ($CalConvMoisG.text -eq $table_mois[$i]) {break} }
$date = $CalConvJourG.text + "/" + $i + "/" + $CalConvAnG.text
if ([string]$date -as [DateTime] -and [int]$CalConvAnG.text -ne 0) {
$dateM = new-object System.DateTime($CalConvAnG.text, $i, $CalConvJourG.text)
if ($dateM -ge $calendarConv.MinDate -and $dateM -le $calendarConv.MaxDate) 
{$CalendarConv.name ='x' ; $calendarConv.SelectionStart = $dateM ; $CalendarConv.name ='y' ; $calendarConv.visible = $true} else {$calendarConv.visible = $false}

$j = [string]$i
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select case when julien > 2299160 then 1 + julien - 7*(julien/7) else '' end j
from (select cast(strftime('%J', dateg) as integer) julien, 1 + strftime('%J', dateg) - 7*((strftime('%J', dateg))/7) j
from (select '" + $CalConvAnG.text + "-" + $j.padleft(2,"0") + "-" + (""+$CalConvJourG.text).padleft(2,"0") + " 12:00' dateg)
)")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) {$CalConvJsemaine.text = $table_jour[[int]$lecture.getValue(0)]}
$lecture.Close()
$cmd.Dispose()

} else {$calendarConv.visible = $false}} else {$calendarConv.visible = $false}
} 
}

function modifj {
# [System.Windows.Forms.Messagebox]::Show($CalConvModifJ.text,"modifj")
if ($CalConvModifJ.text -eq "y") {
$CalConvModifG.text = "x" ; $CalConvJourG.text = "" ; $CalConvMoisG.text = "" ; $CalConvAnG.text = "" ; $CalConvModifG.text = "y" ; $CalConvJsemaine.text = "" ; $calendarConv.visible = $false
$CalConvModifH.text = "x" ; $CalConvJourH.text = "" ; $CalConvMoisH.text = "" ; $CalConvAnH.text = "" ; $CalConvModifH.text = "y" 

if ($CalConvJourJ.text -ne "" -and $CalConvMoisJ.text -ne "" -and $CalConvAnJ.text -ne "") {
if ($CalConvJourJ.text -match "^[\d\.]+$" -and $CalConvAnJ.text -match "^[\d\.]+$") {
for($i = 1;$i -lt 13;$i++){if ($CalConvMoisJ.text -eq $table_mois[$i]) {break} }
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select case when (jour >=32) or (mois in (4, 6, 9, 11) and jour >=31) or (mois= 2 and jour >= 30) or (mois= 2 and jour >= 29 and an-4*(an/4) <> 0) or jour = 0 or an = 0 then 'erreur-j'
when cast(julien as integer) > 4642999 then 'erreur-max' /* bug au del de cette date */
else 1 + julien - 7*(julien/7) end j
from (select jour + case mois when 1 then 0 when 2 then 31 when 3 then 59 when 4 then 90 when 5 then 120 when 6 then 151 when 7 then 181 when 8 then 212 when 9 then 243 when 10 then 273 when 11 then 304 when 12 then 334 end 
+ (an - 1)* 365 + ((an-1)/4) + case when an-4*(an/4) = 0 and mois > 2 then 1 else 0 end + 1721423  julien , jour,mois,an
from (select " + $CalConvJourJ.text + " jour, " + $i + " mois, " + $CalConvAnJ.text + " an)
)")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) {[string]$js = $lecture.getValue(0)}
$lecture.Close()
$cmd.Dispose()
if ($js -ne "erreur-j") {
if ($js -eq "erreur-max") {$res = [System.Windows.Forms.Messagebox]::Show($table_lib[22],$table_lib[1],1,"16")} else {$CalConvJsemaine.text = $table_jour[[int]$js]} 
}
}
} 

} 
}

function modifh {
if ($CalConvModifH.text -eq "y") {
$CalConvModifG.text = "x" ; $CalConvJourG.text = "" ; $CalConvMoisG.text = "" ; $CalConvAnG.text = "" ; $CalConvModifG.text = "y" ; $CalConvJsemaine.text = "" ; $calendarConv.visible = $false
$CalConvModifJ.text = "x" ; $CalConvJourJ.text = "" ; $CalConvMoisJ.text = "" ; $CalConvAnJ.text = "" ; $CalConvModifJ.text = "y" ; $CalConvJsemaine.text = ""
} 
}

function ConvG {
ConvGJ
if ([string]$CalConvJourJ.text -ne "") {ConvJH}
}

function ConvJ {
ConvJG
ConvJH
}

function ConvH {
ConvHJ
if ([string]$CalConvJourJ.text -ne "") {ConvJG}
}


function ConvGJ {
$CalConvMG = "00"
for($i = 1;$i -lt 13;$i++){if ($CalConvMoisG.text -eq $table_mois[$i]) {$j = [string]$i ; $CalConvMG = $j.padleft(2,"0")} }
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select /* dateg, julien, */
case when cast(julien as integer) < 2299161 then 'erreur-HC' when julien is null then 'erreur' when dateg <> strftime('%Y-%m-%d %H:%M',julien) then 'erreur-bug'  
when cast(julien as integer) > 4642999 then 'erreur-max' /* bug au del de cette date */
else datej end datej, jour, mois, an 
from (select dateg, julien, an||'-'||case when length(mois)=1 then '0' else '' end||mois||'-'||case when length(jour)=1 then '0' else '' end||jour datej, jour, mois, an 
from (select dateg, julien, b, c, d, e, jour, mois, case when mois > 2 then c - 4716 else c - 4715 end  an
from (select dateg, julien, b, c, d, e, b - d - cast( (30.6001 * e) as integer) jour, case when e < 14 then e - 1 else e - 13 end mois
from (select dateg, julien, b, c, cast ( (365.25 * c) as integer) d, cast( ((b - cast ( (365.25 * c) as integer)) / 30.6001) as integer) e
from (select dateg, julien, julien + 1524 b, cast( ((julien + 1524 - 122.1) / 365.25) as integer) c
from (select strftime('%J', dateg) julien, dateg
from (select '" + $CalConvAnG.text + "-" + $CalConvMG + "-" + (""+$CalConvJourG.text).padleft(2,"0") + " 12:00' dateg)
))))))
")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) {$dateJ = $lecture.getValue(0) ; $jourJ = $lecture.getValue(1) ; $moisJ = $lecture.getValue(2) ; $anJ = $lecture.getValue(3)}
$lecture.Close()
$cmd.Dispose()
if ($dateJ -eq "erreur-max") {$res = [System.Windows.Forms.Messagebox]::Show($table_lib[21],$table_lib[1],1,"16")}

$CalConvModifJ.text = "x"
if ($dateJ.substring(0,6) -eq "erreur") {$CalConvJourJ.text = "" ; $CalConvMoisJ.text = "" ; $CalConvAnJ.text = "" ; $CalConvJsemaine.text = ""} else {
$CalConvJourJ.text = $jourJ
$CalConvMoisJ.text = $table_mois[[int]$moisJ]
$CalConvAnJ.text = $anJ
}
$CalConvModifJ.text = "y"

} 

function ConvJH {
if ($CalConvJourJ.text -match "^[\d\.]+$" -and $CalConvAnJ.text -match "^[\d\.]+$") {
if ($CalConvJourJ.text -eq "") {$CalConvJJ = "''"} else {$CalConvJJ = $CalConvJourJ.text}
if ($CalConvAnJ.text -eq "") {$CalConvAJ = "''"} else {$CalConvAJ = $CalConvAnJ.text}
$CalConvMJ = "00"
for($i = 1;$i -lt 13;$i++){if ($CalConvMoisJ.text -eq $table_mois[$i]) {$j = [string]$i ; $CalConvMJ = $j.padleft(2,"0")} }
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select /* julien,jour, mois, an, julien_1_1_H, m, moish, julien_1_m_H, m,  */
case when (jour >=32) or (mois in (4, 6, 9, 11) and jour >=31) or (mois= 2 and jour >= 30) or (mois= 2 and jour >= 29 and an-4*(an/4) <> 0) or jour = 0 then 'erreur-j'
when cast(julien as integer) < 1948440 then 'erreur-HC' when julien is null then 'erreur'
when cast(julien as integer) > 4642999 then 'erreur-max' /* bug au del de cette date */
else ((julien - julien_1_m_H) + 1)||'/'||moish||'/'||anh end dateh,
(julien - julien_1_m_H) + 1 jourh, moish, anh
from (select julien,jour, mois, an, anh, julien_1_1_H, m, moish,
1 + cast(a as integer) + case a-cast(a as integer) when 0 then 0 else 1 end + (anh - 1)*354 + cast(b as integer) + 1948439 julien_1_m_H
from (select julien,jour, mois, an, anh, julien_1_1_H, m, moish, (29.5 * (moish - 1)) a, ((3 + (11 * anh)) / 30) b
from (select julien,jour, mois, an, anh, julien_1_1_H, m, min (12,cast(m as integer) + case when m-cast(m as integer) = 0 or m < 0 then 0 else 1 end + 1) moish
from (select julien,jour, mois, an, anh, julien_1_1_H, (julien - (29 + julien_1_1_H)) / 29.5 m
from (select julien,jour, mois, an, anh, 1 + (anh - 1)*354 + cast(((3 + (11 * anh)) / 30) as integer) + 1948439 julien_1_1_H
from (select julien,jour,mois,an,cast( (((30 * (julien - 1948439)) + 10646) / 10631) as integer) anh
from (select jour + case mois when 1 then 0 when 2 then 31 when 3 then 59 when 4 then 90 when 5 then 120 when 6 then 151 when 7 then 181 when 8 then 212 when 9 then 243 when 10 then 273 when 11 then 304 when 12 then 334 end 
+ (an - 1)* 365 + ((an-1)/4) + case when an-4*(an/4) = 0 and mois > 2 then 1 else 0 end + 1721423  julien , jour,mois,an
from (select " + $CalConvJJ + " jour, " + $CalConvMJ + " mois, " + $CalConvAJ + " an)
)))))))
")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) { $dateH = $lecture.getValue(0) ; $jourH = $lecture.getValue(1) ; $moisH = $lecture.getValue(2) ; $anH = $lecture.getValue(3)}
$lecture.Close()
$cmd.Dispose()
##  (fait dans ConvJG) if ($dateH -eq "erreur-max") {$res = [System.Windows.Forms.Messagebox]::Show($table_lib[21],$table_lib[1],1,"16")}

$CalConvModifH.text = "x"
if ($dateH.substring(0,6) -eq "erreur") {$CalConvJourH.text = "" ; $CalConvMoisH.text = "" ; $CalConvAnH.text = ""} else {
$CalConvJourH.text = $jourH
$CalConvMoisH.text = $table_moisH[[int]$moisH]
$CalConvAnH.text = $anH
}
$CalConvModifH.text = "y"

}
}

function ConvJG {
if ($CalConvJourJ.text -match "^[\d\.]+$" -and $CalConvAnJ.text -match "^[\d\.]+$") {
if ($CalConvJourJ.text -eq "") {$CalConvJJ = "''"} else {$CalConvJJ = $CalConvJourJ.text}
if ($CalConvAnJ.text -eq "") {$CalConvAJ = "''"} else {$CalConvAJ = $CalConvAnJ.text}
$CalConvMJ = "00"
for($i = 1;$i -lt 13;$i++){if ($CalConvMoisJ.text -eq $table_mois[$i]) {$j = [string]$i ; $CalConvMJ = $j.padleft(2,"0")} }
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select case when cast(an||case when length(mois)=1 then '0' else '' end||mois||case when length(jour)=1 then '0' else '' end||jour as integer) < 15821005 then 'erreur-HC' when julien is null then 'erreur'
when (jour >=32) or (mois in (4, 6, 9, 11) and jour >=31) or (mois= 2 and jour >= 30) or (mois= 2 and jour >= 29 and an-4*(an/4) <> 0) or jour = 0 then 'erreur-j'
when cast(julien as integer) > 4642999 then 'erreur-max' /* bug au del de cette date */
else strftime('%Y/%m/%d',julien) end dateg, jour, mois, an, julien
from (select jour + case mois when 1 then 0 when 2 then 31 when 3 then 59 when 4 then 90 when 5 then 120 when 6 then 151 when 7 then 181 when 8 then 212 when 9 then 243 when 10 then 273 when 11 then 304 when 12 then 334 end 
+ (an - 1)* 365 + ((an-1)/4) + case when an-4*(an/4) = 0 and mois > 2 then 1 else 0 end + 1721423  julien , jour,mois,an
from (select " + $CalConvJJ + " jour, " + $CalConvMJ + " mois, " + $CalConvAJ + " an)
)
")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) { $dateG = $lecture.getValue(0)}
$lecture.Close()
$cmd.Dispose()

if ($dateG -eq "erreur-max") {$res = [System.Windows.Forms.Messagebox]::Show($table_lib[22],$table_lib[1],1,"16")}

$CalConvModifG.text = "x"
$CalendarConv.name = "x"
if ($dateg.substring(0,6) -eq "erreur") {$CalConvJourG.text = "" ; $CalConvMoisG.text = "" ; $CalConvAnG.text = ""
#  $CalConvJsemaine.text = "" 
$CalendarConv.visible = $false
} else {
$CalConvJourG.text = $dateg.substring(8,2).trimstart("0")
$CalConvMoisG.text = $table_mois[[int]$dateg.substring(5,2)]
$CalConvAnG.text = $dateg.substring(0,4)
for($i = 1;$i -lt 13;$i++){if ($CalConvMoisG.text -eq $table_mois[$i]) {break} }
$dateGG = new-object System.DateTime($CalConvAnG.text, $i, $CalConvJourG.text) 
if ($dateGG -ge $calendarConv.MinDate -and $dateGG -le $calendarConv.MaxDate) {$CalendarConv.SelectionStart = $dateGG ; $CalendarConv.visible = $true} else {$CalendarConv.visible = $false}
}
$CalConvModifG.text = "y"
$CalendarConv.name = "y"

}
}

function ConvHJ {
if ($CalConvJourH.text -match "^[\d\.]+$" -and $CalConvAnH.text -match "^[\d\.]+$") {
if ($CalConvJourH.text -eq "") {$CalConvJH = "''"} else {$CalConvJH = $CalConvJourH.text}
if ($CalConvAnH.text -eq "") {$CalConvAH = "''"} else {$CalConvAH = $CalConvAnH.text}
$CalConvMH = "00"
for($i = 1;$i -lt 13;$i++){if ($CalConvMoisH.text -eq $table_moisH[$i]) {$j = [string]$i ; $CalConvMH = $j.padleft(2,"0")} }
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select case when cast(julien as integer) > 2299160 then dateg end dateg, julien, jour, mois, an,
jourj , moisj, anj, case when cast(julien as integer) < 1948440 then 'erreur-HC' 
when (jour >=31) then 'erreur-j' when (mois >=13) then 'erreur-m' when (mois <> moish) or jour = 0 then 'erreur-jj'
when cast(julien as integer) > 4642999 then 'erreur-max' /* bug au del de cette date */
else datej end datej,moish
from (select dateg, julien, jour, mois, an,jourj , moisj, anj, anj||'/'||case when length(moisj)=1 then '0' else '' end||moisj||'/'||case when length(jourj)=1 then '0' else '' end||jourj datej,
min (12,cast(m as integer) + case when m-cast(m as integer) = 0 or m < 0 then 0 else 1 end + 1) moish /* rebouclage pour l'erreur 30 de m = 1 de m + 1 */
from (select dateg, julien, jour, mois, an, b - d - cast( (30.6001 * e) as integer) jourj , moisj, case when (moisj > 2) then (c - 4716) else (c - 4715) end anj,
julien_1_1_H, (julien - (29 + julien_1_1_H)) / 29.5 m /* rebouclage pour l'erreur 30 de m = 1 de m + 1 */
from (select dateg, julien, jour, mois, an, b, c, d, e, case when (e < 14) then (e - 1) else (e - 13) end moisj,
1 + (an - 1)*354 + cast(((3 + (11 * an)) / 30) as integer) + 1948439 julien_1_1_H /* rebouclage pour l'erreur 30 de m = 1 de m + 1 */
from (select dateg, julien, jour, mois, an, b, c, cast ( (365.25 * c) as integer) d, cast ( ((b - cast ( (365.25 * c) as integer)) / 30.6001) as integer) e
from (select dateg, julien, jour, mois, an, julien + 1524 b, cast ( ((julien + 1524 - 122.1) / 365.25) as integer) c
from (select strftime('%Y/%m/%d',julien) dateg, julien, jour, mois, an
from (select jour, mois, an, jour + cast(a as integer) + case a-cast(a as integer) when 0 then 0 else 1 end + (an - 1)*354 + cast(b as integer) + 1948439 julien
from (select jour,mois, an,
(29.5 * (mois - 1)) a, ((3 + (11 * an)) / 30) b
from (select " + $CalConvJH + " jour, " + $CalConvMH + " mois, " + $CalConvAH + " an)
))))))))
")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) {$dateJ = $lecture.getValue(8) ; $jourJ = $lecture.getValue(5) ; $moisJ = $lecture.getValue(6) ; $anJ = $lecture.getValue(7)}
$lecture.Close()
$cmd.Dispose()
if ($dateJ -eq "erreur-max") {$res = [System.Windows.Forms.Messagebox]::Show($table_lib[23],$table_lib[1],1,"16")}

$CalConvModifJ.text = "x"
if ($dateJ.substring(0,6) -eq "erreur") {$CalConvJourJ.text = "" ; $CalConvMoisJ.text = "" ; $CalConvAnJ.text = "" ; $CalConvJsemaine.text = ""} else {
$CalConvJourJ.text = $jourJ
$CalConvMoisJ.text = $table_mois[[int]$moisJ]
$CalConvAnJ.text = $anJ

if ($CalConvJourJ.text -ne "" -and $CalConvMoisJ.text -ne "" -and $CalConvAnJ.text -ne "") {
if ($CalConvJourJ.text -match "^[\d\.]+$" -and $CalConvAnJ.text -match "^[\d\.]+$") {
for($i = 1;$i -lt 13;$i++){if ($CalConvMoisJ.text -eq $table_mois[$i]) {break} }
$cmd = New-Object -TypeName System.Data.SQLite.SQLiteCommand
$cmd.CommandText = ("select case when (jour >=32) or (mois in (4, 6, 9, 11) and jour >=31) or (mois= 2 and jour >= 30) or (mois= 2 and jour >= 29 and an-4*(an/4) <> 0) or jour = 0 then 'erreur-j'
when cast(julien as integer) > 4642999 then 'erreur-max' /* bug au del de cette date */
else 1 + julien - 7*(julien/7) end j
from (select jour + case mois when 1 then 0 when 2 then 31 when 3 then 59 when 4 then 90 when 5 then 120 when 6 then 151 when 7 then 181 when 8 then 212 when 9 then 243 when 10 then 273 when 11 then 304 when 12 then 334 end 
+ (an - 1)* 365 + ((an-1)/4) + case when an-4*(an/4) = 0 and mois > 2 then 1 else 0 end + 1721423  julien , jour,mois,an
from (select " + $CalConvJourJ.text + " jour, " + $i + " mois, " + $CalConvAnJ.text + " an)
)")
$cmd.Connection = $global:conn_mem
$lecture=$cmd.ExecuteReader()
while ($lecture.Read()) {[string]$js = $lecture.getValue(0)}
$lecture.Close()
$cmd.Dispose()
if ($js -ne "erreur-j") {
if ($js -eq "erreur-max") {$res = [System.Windows.Forms.Messagebox]::Show($table_lib[22],$table_lib[1],1,"16")} else {
$CalConvJsemaine.text = $table_jour[[int]$js]} 
}
}
} 

}
$CalConvModifJ.text = "y"

}
}

####################################################################################################
#
# Affichage
#
####################################################################################################

$consolePtr = [Console.Window]::GetConsoleWindow()
[Console.Window]::ShowWindow($consolePtr, 0)

$CalConvForm.showdialog()

$CalConvForm.close
if ($global:conn_mem.state -eq "Open") {$global:conn_mem.close()}
if ($global:conn_mem.state -eq "Closed") {$global:conn_mem.dispose()}



